// SPDX-FileCopyrightText: 2025 g10 code GmbH
// SPDX-Contributor: Carl Schwan <carl.schwan@gnupg.com>
// SPDX-License-Identifier: GPL-2.0-or-later

export async function download(item, ews, accessToken) {
  if (ews) {
    return new Promise((resolve, reject) => {
      const request =
        '<?xml version="1.0" encoding="utf-8"?>' +
        '<soap:Envelope xmlns:xsi="https://www.w3.org/2001/XMLSchema-instance"' +
        '               xmlns:xsd="https://www.w3.org/2001/XMLSchema"' +
        '               xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/"' +
        '               xmlns:t="http://schemas.microsoft.com/exchange/services/2006/types">' +
        '  <soap:Header>' +
        '    <RequestServerVersion Version="Exchange2013" xmlns="http://schemas.microsoft.com/exchange/services/2006/types" soap:mustUnderstand="0" />' +
        '  </soap:Header>' +
        '  <soap:Body>' +
        '    <GetItem xmlns="http://schemas.microsoft.com/exchange/services/2006/messages">' +
        '      <ItemShape>' +
        '        <t:BaseShape>Default</t:BaseShape>' +
        '        <t:IncludeMimeContent>true</t:IncludeMimeContent>' +
        '        <t:AdditionalProperties>' +
        '          <t:FieldURI FieldURI="item:ParentFolderId"/>' +
        '        </t:AdditionalProperties>' +
        '      </ItemShape>' +
        '      <ItemIds><t:ItemId Id="' + item.itemId + '"/></ItemIds>' +
        '    </GetItem>' +
        '  </soap:Body>' +
        '</soap:Envelope>';

      Office.context.mailbox.makeEwsRequestAsync(request, (asyncResult) => {
        if (asyncResult.status !== Office.AsyncResultStatus.Succeeded) {
          const err = asyncResult.error;
          reject(err.name + ': ' + err.message);
          return;
        }
        const parser = new DOMParser();
        const xmlDoc = parser.parseFromString(asyncResult.value, "text/xml");

        const mimeContent = xmlDoc.getElementsByTagName('t:MimeContent')[0].innerHTML;
        const folderId = xmlDoc.getElementsByTagName('t:ParentFolderId')[0];
        resolve({content: atob(mimeContent), folderId: folderId.getAttribute('Id')});
      })
    })
  } else {
    const response = await fetch(
      `https://graph.microsoft.com/v1.0/me/messages/${item.itemId.replace('/', '-')}/$value`,
      {
        headers: {Authorization: accessToken},
      }
    );

    if (response.ok) {
      const content = await response.text();

      const responseDetails = await fetch(
        `https://graph.microsoft.com/v1.0/me/messages/${item.itemId.replace('/', '-')}/`,
        {
          headers: {Authorization: accessToken},
        }
      );

      if (responseDetails.ok) {
        const details = await responseDetails.json();
        return {content, folderId: Office.context.mailbox.convertToEwsId(details.parentFolderId, Office.MailboxEnums.RestVersion.v2_0) };
      }
    }
    return {content: '', folderId: ''}
  }
}