// SPDX-FileCopyrightText: 2023 g10 code GmbH
// SPDX-Contributor: Carl Schwan <carl.schwan@gnupg.com>
// SPDX-License-Identifier: GPL-2.0-or-later

#include "staticcontroller.h"

#include "http_debug.h"
#include <QDebug>
#include <QFile>
#include <QStandardPaths>

using namespace Qt::Literals::StringLiterals;

QHttpServerResponse StaticController::homeAction(const QHttpServerRequest &)
{
    const auto basePath = QStandardPaths::locate(QStandardPaths::GenericDataLocation, u"gpgol-web/"_s, QStandardPaths::LocateDirectory);
    QFile file(basePath + u"index.html"_s);
    if (!file.open(QIODeviceBase::ReadOnly)) {
        qCWarning(HTTP_LOG) << file.errorString() << file.fileName();
        return QHttpServerResponse(QHttpServerResponder::StatusCode::NotFound);
    }

    return QHttpServerResponse("text/html", file.readAll());
}

QHttpServerResponse StaticController::testAction(const QHttpServerRequest &request)
{
    if (request.url().scheme() == QStringLiteral("https")) {
        return QHttpServerResponse("text/html", "<html><head></head><body>Connection with GpgOL background service working.</body></html>");
    }
    return QHttpServerResponse("text/html", "<html><head></head><body>Message recieved without https</body></html>");
}

QHttpServerResponse StaticController::assetsAction(QString fileName, const QHttpServerRequest &)
{
    const auto basePath = QStandardPaths::locate(QStandardPaths::GenericDataLocation, u"gpgol-web/assets/"_s, QStandardPaths::LocateDirectory);
    QFile file(basePath + fileName);
    if (!file.open(QIODeviceBase::ReadOnly)) {
        qCWarning(HTTP_LOG) << file.errorString() << file.fileName();
        return QHttpServerResponse(QHttpServerResponder::StatusCode::NotFound);
    }

    if (fileName.endsWith(u".png"_s)) {
        return QHttpServerResponse("image/png", file.readAll());
    } else if (fileName.endsWith(u".js"_s)) {
        return QHttpServerResponse("text/javascript", file.readAll());
    } else if (fileName.endsWith(u".css"_s)) {
        return QHttpServerResponse("text/css", file.readAll());
    }
    return QHttpServerResponse("text/plain", file.readAll());
}
