#include "utils/formatter.h"
#include <QTest>

class FormatterTest : public QObject
{
    Q_OBJECT
private Q_SLOTS:
    void fingerprintFormatterTest();
    void fingerprintFormatterTest_data();
};

void FormatterTest::fingerprintFormatterTest()
{
    QFETCH(QByteArray, fingerprint);
    QFETCH(QString, expectedResult);
    auto result = Formatter::formatX509Fingerprint(fingerprint);
    QCOMPARE(result, expectedResult);
}

void FormatterTest::fingerprintFormatterTest_data()
{
    QTest::addColumn<QByteArray>("fingerprint");
    QTest::addColumn<QString>("expectedResult");

    QTest::addRow("0 bytes") << QByteArray() << QString();
    QTest::addRow("1 byte") << QByteArray("a") << QString();
    QTest::addRow("3 bytes") << QByteArray("aaa") << QString();
    QTest::addRow("2 bytes") << QByteArray("aa") << QStringLiteral("AA");
    QTest::addRow("4 bytes") << QByteArray("aaaa") << QStringLiteral("AA:AA");
    QTest::addRow("4 bytes, some upper") << QByteArray("aaAA") << QStringLiteral("AA:AA");
    QTest::addRow("non-hex") << QByteArray("axqa") << QString();
    QTest::addRow("some fingeprint") << QByteArray("776AFA15CD86BF306269C3961633F135180B9198")
                                     << QStringLiteral("77:6A:FA:15:CD:86:BF:30:62:69:C3:96:16:33:F1:35:18:0B:91:98");
}

QTEST_GUILESS_MAIN(FormatterTest);

#include "formattertest.moc"
